
<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../db.php';

$site = $_GET['site_id'] ?? null;
$stream = $_GET['stream'] ?? null;
$hours = intval($_GET['hours'] ?? '24');
if (!$site || !$stream) { http_response_code(400); echo json_encode(["error"=>"missing site_id or stream"]); exit; }

$map = [
  "ac" => ["table"=>"ac_telemetry", "cols"=>"ts, v_l1, v_l2, v_l3, i_l1, i_l2, i_l3, power_kw"],
  "battery" => ["table"=>"battery_telemetry", "cols"=>"ts, soc_pct, soh_pct, voltage_v, current_a, temp_c"],
  "solar" => ["table"=>"solar_telemetry", "cols"=>"ts, power_kw, energy_kwh_day, energy_kwh_month"],
  "generator" => ["table"=>"gen_telemetry", "cols"=>"ts, fuel_level_pct, engine_hours, load_pct"],
  "dc" => ["table"=>"dc_telemetry", "cols"=>"ts, voltage_v, current_a"],
];
if (!isset($map[$stream])) { http_response_code(400); echo json_encode(["error"=>"unsupported stream"]); exit; }

$q = $map[$stream];
$sql = "SELECT {$q['cols']} FROM {$q['table']} WHERE site_id=? AND ts >= (NOW() - INTERVAL ? HOUR) ORDER BY ts ASC";
$stmt = db()->prepare($sql);
$stmt->execute([$site, $hours]);
echo json_encode($stmt->fetchAll());
